<?php
/* --------------------------------------------------------------
   GambioAfterbuyAjaxController.inc.php 2018-05-29
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2018 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

class GambioAfterbuyAjaxController extends AdminHttpViewController
{
    public function actionSendOrder()
    {
        if (!$this->_isAdmin()) {
            throw new AuthenticationException('No admin privileges. Please contact the administrator.');
        }
        
        $response = [];
        $orderId  = (int)$this->_getQueryParameter('orderId');
        $txt      = MainFactory::create('LanguageTextManager', 'afterbuy');
        
        try {
            $afterbuySender = MainFactory::create('AfterbuyOrderSender', $orderId);
            $afterbuySender->processOrder();
            $response['message'] = $txt->get_text('sent_successfully');
        } catch (AfterbuyException $e) {
            $response['message'] = $txt->get_text('sent_unsuccessfully');
            $response['message'] .= "\n" . $e->getMessage();
        }
        
        return MainFactory::create('JsonHttpControllerResponse', $response, ['Content-Type: application/json']);
    }
    
    
    /**
     * Check if the customer is the admin.
     *
     * @return bool Is the customer the admin?
     */
    protected function _isAdmin()
    {
        try {
            $this->validateCurrentAdminStatus();
            
            return true;
        } catch (LogicException $exception) {
            return false;
        }
    }
}
